/*
 * Decompiled with CFR 0.152.
 */
package com.instalments.domain.use_case;

import com.dao.util.BulkInsertHelper;
import com.dto.LoginDto;
import com.instalments.data.InstalmentEntity;
import com.utility.CallApi;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.MyHolooMessageMaker;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class InstalmentBulkInsert
extends BulkInsertHelper<InstalmentEntity> {
    public InstalmentBulkInsert(DbConnection dbConnection) {
        super(dbConnection);
    }

    protected String getIdFieldName() {
        return "[Index]";
    }

    protected boolean getIdentityInsertOn() {
        return true;
    }

    protected List<String> getAllIds(List<InstalmentEntity> dtoList) {
        return dtoList.stream().map(dto -> String.valueOf(dto.getIndex())).collect(Collectors.toList());
    }

    protected String appendInsertValues(InstalmentEntity dto) {
        return "'" + dto.getCustomerCode() + "', '" + dto.getDueDate() + "', " + dto.getIndex() + ", " + dto.getToPayAmount() + ", " + ConvertStr.getBoolToInt((Boolean)dto.isHlpSettled()) + ", " + ConvertStr.getBoolToInt((Boolean)dto.isSettled()) + ", " + dto.getInstalmentNumber() + ", '" + dto.getSettleDate() + "', '" + dto.getDescription() + "', " + ConvertStr.getBoolToInt((Boolean)dto.isOurPayment()) + ", " + dto.getLoanCode() + ", " + ConvertStr.toQuotedSqlStr((String)String.valueOf(dto.getDocCode())) + ", " + ConvertStr.toQuotedSqlStr((String)String.valueOf(dto.getOverdueDocumentCode())) + ", '" + dto.getRegardedTo() + "', " + dto.getInterestFormulaID() + ", " + dto.getFineFormulaID() + ", " + dto.getInterestPrice() + ", '" + dto.getSettleDescription() + "', " + dto.getFinePrice() + ", " + dto.getInstalmentCount() + ", " + dto.getNumFact() + ", " + dto.getTotalPrice() + ", '" + dto.getCashName() + "', '" + dto.getDesc1() + "', '" + dto.getDesc2() + "', " + ConvertStr.getBoolToInt((Boolean)dto.isTypeCustomer()) + ", " + ConvertStr.toQuotedSqlStr((String)String.valueOf(dto.getInterestDocumentCode())) + ", '" + dto.getDueDateJalali() + "', '" + dto.getIssueDate() + "'";
    }

    protected String getTableName() {
        return "GHEST";
    }

    protected String[] getColumnsToInsertInto() {
        return new String[]{"c_code", "d_par_ghest", "[index]", "mablagh_ghest", "HlP_GH_Vosol", "gh_vosol", "sh_gh", "dar_ghest", "tozihat", "dar_par", "gh_id", "sanad_dar", "SanadTakhir", "gh_babat", "SoodFormul_ID", "JarimeFormul_ID", "PriceSood", "CommentVosol", "Jarimeh", "FewGhest", "Num_Fact", "mab_col", "cash_name", "ghest_comment1", "ghest_comment2", "TypeCust", "Sanad_Sood", "d_par_ghestStr", "ExportDate"};
    }

    protected List<Map<String, Object>> callApi(LoginDto loginDto, MyHolooMessageMaker messageMaker) {
        return CallApi.callApiGetNotify((LoginDto)loginDto, (String)"Instalment", (int)0, (String)messageMaker.makeCodes(), null, (String)messageMaker.makeMessage(this.getTableName(), false), (String)"instalmentCallApi", (DbConnection)this.dbConnection);
    }

    protected String getCodeForWebhook(InstalmentEntity dto) {
        return String.valueOf(dto.getIndex());
    }

    protected Integer getUpdateState(InstalmentEntity dto) {
        return dto.getIsUpdate();
    }
}

